#!/bin/bash

# Docker version management script
# Usage: ./development_scripts/version.sh [major|minor|patch|get]

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_DIR="$(dirname "$SCRIPT_DIR")"
PACKAGE_JSON="$PROJECT_DIR/source/package.json"

# Get current version from package.json
get_version() {
    if [ -f "$PACKAGE_JSON" ]; then
        grep '"version"' "$PACKAGE_JSON" | sed 's/.*"version": *"\([^"]*\)".*/\1/'
    else
        echo "1.0.0"
    fi
}

# Parse version into array
parse_version() {
    local version=$1
    IFS='.' read -ra VERSION_PARTS <<< "$version"
    MAJOR="${VERSION_PARTS[0]}"
    MINOR="${VERSION_PARTS[1]}"
    PATCH="${VERSION_PARTS[2]}"
}

# Increment version
increment_version() {
    local current=$(get_version)
    parse_version "$current"

    case $1 in
        major)
            MAJOR=$((MAJOR + 1))
            MINOR=0
            PATCH=0
            ;;
        minor)
            MINOR=$((MINOR + 1))
            PATCH=0
            ;;
        patch|*)
            PATCH=$((PATCH + 1))
            ;;
    esac

    local new_version="${MAJOR}.${MINOR}.${PATCH}"

    # macOS sed
    sed -i '' "s/\"version\": *\"[^\"]*\"/\"version\": \"$new_version\"/" "$PACKAGE_JSON"

    echo "$new_version"
}

# Main
case ${1:-get} in
    major|minor|patch)
        increment_version $1
        ;;
    get)
        get_version
        ;;
    *)
        echo "Usage: $0 [major|minor|patch|get]"
        exit 1
        ;;
esac
