param(
    [Parameter(Mandatory=$true)]
    [ValidateSet("major", "minor", "patch")]
    [string]$BumpType
)

$packagePath = Join-Path $PSScriptRoot "..\source\package.json"
$json = Get-Content $packagePath -Raw
$pkg = $json | ConvertFrom-Json
$parts = $pkg.version -split '\.'

switch ($BumpType) {
    "major" {
        $parts[0] = [int]$parts[0] + 1
        $parts[1] = "0"
        $parts[2] = "0"
    }
    "minor" {
        $parts[1] = [int]$parts[1] + 1
        $parts[2] = "0"
    }
    "patch" {
        $parts[2] = [int]$parts[2] + 1
    }
}

$newVersion = $parts -join '.'
$json = $json -replace '"version":\s*"[^"]+"', "`"version`": `"$newVersion`""
Set-Content $packagePath $json -NoNewline
Write-Host "Version bumped to $newVersion"
