// routes/logs.js - Log viewing routes
import express from "express";
import logger from "../services/logger.js";

const router = express.Router();

/**
 * GET /api/logs - List all log files
 */
router.get("/api/logs", (req, res) => {
  try {
    const logs = logger.listLogFiles();
    return res.json({ success: true, logs });
  } catch (e) {
    logger.error(`Failed to list logs: ${e.message}`);
    return res.status(500).json({ success: false, message: e.message });
  }
});

/**
 * GET /api/logs/:filename - Read a specific log file
 */
router.get("/api/logs/:filename", (req, res) => {
  try {
    const filename = req.params.filename;
    const content = logger.readLogFile(filename);
    return res.json({ success: true, content });
  } catch (e) {
    logger.error(`Failed to read log file: ${e.message}`);
    return res.status(404).json({ success: false, message: e.message });
  }
});

/**
 * GET /api/logs-info - Get log directory info
 */
router.get("/api/logs-info", (req, res) => {
  try {
    const logsDir = logger.getLogsDirectory();
    return res.json({ success: true, logsDir });
  } catch (e) {
    return res.status(500).json({ success: false, message: e.message });
  }
});

export default router;
