// services/filters.js - DOCCONTROLID prefix filtering utilities

// Check if DOCCONTROLID matches the given prefix pattern
// prefix: e.g., "EC_" or "FUSAPI_"
// The DOCCONTROLID must START with the prefix (case-insensitive) and have content after it
export function isValidPrefixPattern(docControlId, prefix) {
  const str = String(docControlId ?? '').trim();
  if (!str) return false;
  if (!prefix) return true; // No prefix means all records are valid

  const escaped = prefix.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
  const regex = new RegExp('^' + escaped, 'i');
  const match = str.match(regex);
  if (!match) return false;

  const afterPrefix = str.substring(match[0].length);
  return afterPrefix.length > 0;
}

// Legacy function for backward compatibility
export function isValidECPattern(docControlId) {
  return isValidPrefixPattern(docControlId, 'EC_');
}
