// guide.js - User Guide tab module

export async function initGuide() {
  // Add smooth scroll for anchor links
  const tocLinks = document.querySelectorAll('.guide-toc a');
  for (const link of tocLinks) {
    link.onclick = (e) => {
      e.preventDefault();
      const targetId = link.getAttribute('href').substring(1);
      const target = document.getElementById(targetId);
      if (target) {
        target.scrollIntoView({ behavior: 'smooth', block: 'start' });
      }
    };
  }
}

export function cleanupGuide() {
  // No cleanup needed
}
